import os
import glob
import time
import RPi.GPIO as GPIO
from bluetooth import *
from subprocess import Popen, PIPE

os.system('modprobe w1-gpio')
os.system('modprobe w1-therm')

out_Pipe = Popen("./threads", stdin=None, stdout=PIPE)		#establish the pipe from python to c program
in_Pipe = Popen("./threads", stdin=PIPE, stdout=None)		#establish the pipe from c program to python

server_sock=BluetoothSocket( RFCOMM )						#set up bluetooth
server_sock.bind(("",PORT_ANY))
server_sock.listen(1)
 
port = server_sock.getsockname()[1]
 
uuid = "94f39d29-7d6d-437d-973b-fba39e49d4ee"				#establish UUID
 
advertise_service( server_sock, "RaspberryPi",				#broadcast socket
                   service_id = uuid,
                   service_classes = [ uuid, SERIAL_PORT_CLASS ],
                   profiles = [ SERIAL_PORT_PROFILE ], 
                   )
				   
print "Waiting for connection on RFCOMM channel %d" % port	

client_sock, client_info = server_sock.accept()				#find client
print "Accepted connection from ", client_info
	
while True:           
	try:
		in_data = client_sock.recv(1024)					#receive incoming data
		if len(in_data) == 0: break							#determine if it is acceptable data	
		print "received [%s]" % in_data
 
		if 'tempSet' in data:								#determine which piece of data came in
			out_data = data
		elif data == '1':
			out_data = 'alarmOn'
		elif data == '0':
			out_data = 'alarmOff'
		else:
			out_data = 'ERROR - Couldnt read data' 
	    
		out_Pipe.stdin.write(out_data)						#send information down the pipe
		in_Pipe.stdout.read(temp)							#check the pipe from the c program
		
		client_sock.send(temp)								#send the current temp to the android device
		print "sending [%s]" % temp
 
	except IOError:
		pass
 
	except KeyboardInterrupt: 
		client_sock.close()									#close the bluetooth connection
		server_sock.close() 
		
		break